/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.data.gen;

import net.brdle.collectorsreap.Util;
import net.brdle.collectorsreap.common.block.CRBlocks;
import net.brdle.collectorsreap.common.block.PortobelloColonyBlock;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import vectorwing.farmersdelight.common.block.PieBlock;

public class CRBlockStateProvider
extends BlockStateProvider {
    public CRBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "collectorsreap", exFileHelper);
    }

    public static ResourceLocation resourceBlock(String path) {
        return Util.cr("block/" + path);
    }

    protected void registerStatesAndModels() {
        this.pieBlock(CRBlocks.PORTOBELLO_QUICHE);
        this.pieBlock(CRBlocks.LIME_PIE);
        this.stageBlock((Block)CRBlocks.PORTOBELLO_COLONY.get(), PortobelloColonyBlock.COLONY_AGE, new Property[0]);
        this.cross((Block)CRBlocks.PORTOBELLO.get());
        this.crateBlock((Block)CRBlocks.LIME_CRATE.get(), "lime");
        this.crateBlock((Block)CRBlocks.POMEGRANATE_CRATE.get(), "pomegranate");
        this.cakeBlock(CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.WHITE_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.ORANGE_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.MAGENTA_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.LIGHT_BLUE_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.YELLOW_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.LIME_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.PINK_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.GRAY_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.LIGHT_GRAY_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.CYAN_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.PURPLE_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.BLUE_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.BROWN_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.GREEN_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.RED_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.candleCakeBlock(CRBlocks.BLACK_CANDLE_LIME_CAKE, CRBlocks.LIME_CAKE);
        this.cakeBlock(CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.WHITE_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.ORANGE_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.MAGENTA_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.LIGHT_BLUE_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.YELLOW_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.LIME_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.PINK_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.GRAY_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.LIGHT_GRAY_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.CYAN_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.PURPLE_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.BLUE_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.BROWN_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.GREEN_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.RED_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.candleCakeBlock(CRBlocks.BLACK_CANDLE_POMEGRANATE_CAKE, CRBlocks.POMEGRANATE_CAKE);
        this.simpleBlock((Block)CRBlocks.LIME_ICE_CREAM_BLOCK.get());
        this.simpleBlock((Block)CRBlocks.POMEGRANATE_ICE_CREAM_BLOCK.get());
        this.simpleBlock((Block)CRBlocks.URCHIN_TEST_BLOCK.get(), (ModelFile)this.models().cubeBottomTop("urchin_test_block", CRBlockStateProvider.resourceBlock("urchin_test_block_side"), CRBlockStateProvider.resourceBlock("urchin_test_block_bottom"), CRBlockStateProvider.resourceBlock("urchin_test_block_top")));
        this.simpleBlock((Block)CRBlocks.URCHIN_TEST_BRICKS.get());
        this.slabBlock((SlabBlock)CRBlocks.URCHIN_TEST_BRICK_SLAB.get(), CRBlockStateProvider.resourceBlock("urchin_test_bricks"), CRBlockStateProvider.resourceBlock("urchin_test_bricks"));
        this.stairsBlock((StairBlock)CRBlocks.URCHIN_TEST_BRICK_STAIRS.get(), CRBlockStateProvider.resourceBlock("urchin_test_bricks"));
        this.wallBlock((WallBlock)CRBlocks.URCHIN_TEST_BRICK_WALL.get(), CRBlockStateProvider.resourceBlock("urchin_test_bricks"));
        this.simpleBlock((Block)CRBlocks.CHISELED_URCHIN_TEST_BRICKS.get());
        this.simpleBlock((Block)CRBlocks.URCHIN_TEST_TILES.get());
        this.slabBlock((SlabBlock)CRBlocks.URCHIN_TEST_TILE_SLAB.get(), CRBlockStateProvider.resourceBlock("urchin_test_tiles"), CRBlockStateProvider.resourceBlock("urchin_test_tiles"));
        this.stairsBlock((StairBlock)CRBlocks.URCHIN_TEST_TILE_STAIRS.get(), CRBlockStateProvider.resourceBlock("urchin_test_tiles"));
        this.wallBlock((WallBlock)CRBlocks.URCHIN_TEST_TILE_WALL.get(), CRBlockStateProvider.resourceBlock("urchin_test_tiles"));
    }

    public void crateBlock(Block block, String cropName) {
        this.simpleBlock(block, (ModelFile)this.models().cubeBottomTop(Util.name(block), CRBlockStateProvider.resourceBlock(cropName + "_crate_side"), Util.rl("farmersdelight", "block/crate_bottom"), CRBlockStateProvider.resourceBlock(cropName + "_crate_top")));
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(CRBlockStateProvider.resourceBlock(path), this.models().existingFileHelper);
    }

    public void cross(Block block) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().cross("block/" + Util.name(block), CRBlockStateProvider.resourceBlock(Util.name(block)))).renderType("cutout"));
    }

    public void stageBlock(Block block, IntegerProperty ageProperty, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            String stageName = Util.name(block) + "_stage" + String.valueOf(state.m_61143_((Property)ageProperty));
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().cross(stageName, CRBlockStateProvider.resourceBlock(stageName))).renderType("cutout")).build();
        }, ignored);
    }

    public void upperLowerStageBlock(Block block, IntegerProperty ageProperty, EnumProperty<DoubleBlockHalf> halfProperty, Property<?> ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            String name = Util.name(block) + "_" + ((DoubleBlockHalf)state.m_61143_((Property)halfProperty)).m_7912_();
            BlockModelBuilder mod = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name + "_stage" + String.valueOf(state.m_61143_((Property)ageProperty)), Util.cr(name))).texture("side", CRBlockStateProvider.resourceBlock(Util.name(block) + "_side_stage" + String.valueOf(state.m_61143_((Property)ageProperty))))).texture("plant", CRBlockStateProvider.resourceBlock(Util.name(block) + "_plant_" + ((DoubleBlockHalf)state.m_61143_((Property)halfProperty)).m_7912_() + "_stage" + String.valueOf(state.m_61143_((Property)ageProperty))))).texture("particle", CRBlockStateProvider.resourceBlock(Util.name(block) + "_plant_" + ((DoubleBlockHalf)state.m_61143_((Property)halfProperty)).m_7912_() + "_stage" + String.valueOf(state.m_61143_((Property)ageProperty))));
            if (state.m_61143_((Property)halfProperty) == DoubleBlockHalf.UPPER) {
                mod.texture("top", CRBlockStateProvider.resourceBlock(Util.name(block) + "_top_stage" + String.valueOf(state.m_61143_((Property)ageProperty))));
            }
            return ConfiguredModel.builder().modelFile((ModelFile)mod).build();
        }, new Property[]{ignored});
    }

    public void pomegranateBushBlock(Block block, IntegerProperty ageProperty, EnumProperty<DoubleBlockHalf> halfProperty) {
        this.getVariantBuilder(block).forAllStates(state -> {
            String halfStageName = Util.name(block) + "_" + ((DoubleBlockHalf)state.m_61143_((Property)halfProperty)).m_7912_() + "_stage" + String.valueOf(state.m_61143_((Property)ageProperty));
            String name = Util.name(block) + "_stage" + String.valueOf(state.m_61143_((Property)ageProperty));
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)this.models().withExistingParent("block/" + halfStageName, Util.cr(Util.name(block) + "_" + ((DoubleBlockHalf)state.m_61143_((Property)halfProperty)).m_7912_()))).texture("0", CRBlockStateProvider.resourceBlock(name))).build();
        });
    }

    public void pieBlock(RegistryObject<Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            int bites = (Integer)state.m_61143_((Property)PieBlock.BITES);
            String name = Util.name(block);
            Object suffix = bites > 0 ? "_slice" + bites : "";
            BlockModelBuilder mod = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name + (String)suffix, Util.rl("farmersdelight", "pie" + (String)suffix))).texture("top", CRBlockStateProvider.resourceBlock(name + "_top"))).texture("bottom", CRBlockStateProvider.resourceBlock(name + "_bottom"))).texture("side", CRBlockStateProvider.resourceBlock(name + "_side"))).texture("particle", CRBlockStateProvider.resourceBlock(name + "_top"));
            if (bites > 0) {
                mod.texture("inner", CRBlockStateProvider.resourceBlock(name + "_inner"));
            }
            return ConfiguredModel.builder().modelFile((ModelFile)mod).rotationY(((int)((Direction)state.m_61143_((Property)PieBlock.FACING)).m_122435_() + 180) % 360).build();
        });
    }

    public void cakeBlock(RegistryObject<Block> block) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            int bites = (Integer)state.m_61143_((Property)CakeBlock.f_51180_);
            String name = Util.name(block);
            Object suffix = bites > 0 ? "_slice" + bites : "";
            BlockModelBuilder mod = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name + (String)suffix, Util.rl("minecraft", "cake" + (String)suffix))).texture("top", CRBlockStateProvider.resourceBlock(name + "_top"))).texture("bottom", CRBlockStateProvider.resourceBlock(name + "_bottom"))).texture("side", CRBlockStateProvider.resourceBlock(name + "_side"))).texture("particle", CRBlockStateProvider.resourceBlock(name + "_side"));
            if (bites > 0) {
                mod.texture("inside", CRBlockStateProvider.resourceBlock(name + "_inner"));
            }
            return ConfiguredModel.builder().modelFile((ModelFile)mod).build();
        });
    }

    public void candleCakeBlock(RegistryObject<Block> block, RegistryObject<Block> cake) {
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            String lit = (Boolean)state.m_61143_((Property)AbstractCandleBlock.f_151895_) != false ? "_lit" : "";
            String name = Util.name(block);
            String cakeName = Util.name(cake);
            String candle = name.replace("_" + cakeName, "") + lit;
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("block/" + name + lit, Util.rl("minecraft", "template_cake_with_candle"))).texture("bottom", CRBlockStateProvider.resourceBlock(cakeName + "_bottom"))).texture("candle", Util.rl("minecraft", "block/" + candle))).texture("particle", CRBlockStateProvider.resourceBlock(cakeName + "_side"))).texture("side", CRBlockStateProvider.resourceBlock(cakeName + "_side"))).texture("top", CRBlockStateProvider.resourceBlock(cakeName + "_top"))).build();
        });
    }
}

